﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Xml

Public Class MainForm

    '创建要在窗体中使用的常量。
    Private Const controlWidth As Integer = 300
    Private Const charPerLine As Integer = 30
    Private Const lineHeight As Integer = 19

    '创建要在窗体中使用的类变量。
    Private controlCount As Integer = 0
    Private controlLocation As New Point(10, 50)


    '此子例程向窗体中添加一个新按钮，并为其设置在
    '发生 Click 和 MouseHover 事件时将激发的事件处理程序。
    Private Sub btnAddButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAddButton.Click

        '增加控件计数。
        controlCount += 1

        '只允许使用 5 个按钮，这样做只为了简化用户界面的绘制。
        If controlCount <= 5 Then
            ' 创建一个新按钮
            Dim newButton As New Button

            '向窗体中添加属性。
            newButton.Name = "btn" + controlCount.ToString()
            newButton.Text = "btn" + controlCount.ToString()
            newButton.Location = New Point(controlLocation.X + 250, controlLocation.Y)
            controlLocation.Y += newButton.Height + 5

            '添加两个事件处理程序。
            AddHandler newButton.Click, AddressOf myButtonHandler_Click
            AddHandler newButton.MouseHover, AddressOf myButtonHandler_MouseHover

            '向控件集合中添加控件。
            Controls.Add(newButton)
        Else
            '只允许使用 5 个控件以简化 UI。
            MsgBox("You've reached 5 controls. Clear controls to start again.", _
                MsgBoxStyle.OKOnly, Me.Text)
        End If
    End Sub

    '此子例程用于清除页面上动态生成的所有控件。
    '它执行此操作的方法是先移除所有控件，然后调用
    'Visual Studio .NET 自动生成的 InitializeComponent() 子例程。
    '这是将窗体重置为原始状态的
    '的简便方法。
    Private Sub btnClearControls_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClearControls.Click

        '清除所有控件。
        Controls.Clear()

        '再次添加所有原始控件。
        InitializeComponent()

        '将 m_Location 重置为其原始位置。
        controlLocation = New Point(10, 50)

        '重置控件数。
        controlCount = 0

        '再次显示窗体。
        Show()

    End Sub

    '此子例程处理 btnCreateSurvey.Click 事件并创建新的
    'frmSurveyForm。生成的控件将被添加至创建的调查问卷窗体。
    '没有与创建的控件关联的事件
    '处理程序。
    '创建的窗体是一个很普通的窗体，并创建一份调查问卷，其中的问题
    '是根据 Questions.xml 文档中的信息提出的。
    '通过在 XML 文档中更改、添加或移除节点，
    '可以更改调查问卷的结构和形式。
    Private Sub btnCreateSurvey_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCreateSurvey.Click

        '创建显示给用户的新的调查问卷窗体。
        Dim survey As New SurveyForm

        '获取调查问卷窗体的控件集合。
        Dim surveyControls As Control.ControlCollection = survey.SurveyFormControls

        '设置第一个控件的位置。
        Dim location As Point
        location = New Point(10, 10)

        '创建用于读入调查问题的 XML 文档。
        Dim xr As New Xml.XmlDocument
        xr.LoadXml(My.Resources.Questions)

        '获取要在创建的每个控件中使用的标记。
        '如果扩展该示例以划分为不同类型的问题/响应
        '来进行分析，这可能在以后很有用。
        Dim myTag As String = xr.SelectSingleNode("//survey").Attributes("name").Value

        '将调查问卷窗体的标题设置为调查问卷的显示名称。
        survey.SurveyTitle = xr.SelectSingleNode("//survey").Attributes("displayName").Value

        '创建 XmlNodeList 以包含每个问题。填充它。
        Dim nodeList As Xml.XmlNodeList
        nodeList = xr.GetElementsByTagName("question")

        ' 创建一个临时 XML 节点，以便在刚创建的
        ' nodeList 中检索有关节点的信息时使用。
        Dim myNode As XmlNode
        For Each myNode In nodeList
            If Not myNode.Attributes Is Nothing Then
                ' 确定应创建的控件类型。传入所需的信息，
                ' 包括 frmSurveyForm 窗体中的
                ' 控件集合。
                Select Case myNode.Attributes("type").Value
                    Case "dropdown"
                        location = Survey_AddComboBox(myNode, surveyControls, _
                            location, myTag)
                    Case "multilist"
                        location = Survey_AddListBox(myNode, surveyControls, _
                            location, myTag, True)
                    Case "text"
                        location = Survey_AddTextBox(myNode, surveyControls, _
                            location, myTag)
                    Case "radio"
                        location = Survey_AddRadioButtons(myNode, surveyControls, _
                            location, myTag)
                End Select
            End If
        Next

        '设置窗体大小（根据窗体中放置的控件数以及
        '这些控件的尺寸）。
        survey.Width = location.X + controlWidth + 30
        '添加额外的空间，以便为“OK”（确定）和“Cancel”（取消）按钮留出空间。
        survey.Height = location.Y + 75

        '显示窗体。如果您愿意，还可以使用 Show() 方法。
        survey.ShowDialog()

        '向用户显示响应。
        MsgBox(survey.SurveyResponse, MsgBoxStyle.OKOnly, Me.Text)
    End Sub

    '此子例程处理 btnTightlyBoundControls.Click 事件并创建两个
    '紧密绑定的控件。它使用前面定义的事件处理程序
    '来处理事件。这些事件处理程序必须事先定义，
    '除非使用了 Reflection.Emit。
    '这两个控件是 Button 和 TextBox。当按下 Button 时，
    'TextBox 中的文本将显示在 MsgBox 中。为了确保我们知道
    '正在使用哪个 TextBox，将把该控件添加到该 Button 的 Tag
    '属性中。（由于 TextBox 将动态创建，
    '所以创建事件处理程序时，我们不知道 TextBox 的名称。）
    Private Sub btnTightlyBoundControls_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnTightlyBoundControls.Click

        '增加控件数（尽管将添加两个控件，
        '但只加一。）
        controlCount += 1

        '只允许使用 5 个按钮，这样做只为了简化用户界面的绘制。
        If controlCount <= 5 Then

            '创建包含要朗读的文本的 TextBox。
            Dim txtSpeakText As New TextBox

            '设置 TextBox 的一些属性。
            txtSpeakText.Text = "Hello, World"
            txtSpeakText.Name = "txtSpeakText"
            txtSpeakText.Location = New Point(controlLocation.X + 250, controlLocation.Y)
            txtSpeakText.Size = New Size(200, txtSpeakText.Height)

            '将 TextBox 添加到控件集合中。
            Controls.Add(txtSpeakText)

            '增加 m_LocationY 以使下一个控件不会覆盖它。
            controlLocation.Y += txtSpeakText.Height + 5

            '创建用于响应单击的按钮
            '由于此按钮与 TextBox 紧密耦合，后者将为其提供
            '要显示的文本，我们将把前面创建的 TextBox
            '添加为此 Button 的 Tag。
            Dim btnSpeakText As New Button

            '设置 TextBox 的一些属性。
            btnSpeakText.Text = "Speak Text"
            btnSpeakText.Name = "btnSpeakText"
            btnSpeakText.Location = New Point(controlLocation.X + 250, controlLocation.Y)
            btnSpeakText.Size = New Size(100, btnSpeakText.Height)

            '将以前创建的 TextBox 添加到此按钮。
            btnSpeakText.Tag = txtSpeakText

            '将 TextBox 添加到控件集合。
            Controls.Add(btnSpeakText)

            '增加 m_LocationY 以使下一个控件不会覆盖它。
            controlLocation.Y += btnSpeakText.Height + 5

            '添加将在按下按钮时处理事件
            '的事件处理程序。
            AddHandler btnSpeakText.Click, AddressOf SpeakTextClickHandler
        Else
            '只允许使用 5 个控件以简化 UI。
            MsgBox("You've reached 5 controls. Clear controls to start again.", _
                MsgBoxStyle.OKOnly, Me.Text)
        End If

    End Sub

    '此子例程可处理动态生成的所有按钮的 Click
    '事件。在按钮创建时，该子例程即使用 AddHandler
    '函数附加到所有按钮中。
    Private Sub myButtonHandler_Click(ByVal sender As Object, ByVal e As EventArgs)
        '验证触发此事件的控件类型是否确实
        '为 Button。由于此处理程序可以附加到任何
        '事件中，所以这一点很必要。
        If TypeOf sender Is Button Then
            '告知用户哪个 Button 被按下。
            MsgBox(CType(sender, Button).Text + " was pressed!", _
                    MsgBoxStyle.OKOnly, Me.Text)
        End If
    End Sub

    '此子例程可处理动态生成的所有按钮的 MouseHover 事件。
    '在按钮创建时，该子例程即使用 AddHandler
    '函数附加到所有按钮中。
    Private Sub myButtonHandler_MouseHover(ByVal sender As Object, ByVal e As EventArgs)
        '验证触发此事件的控件类型是否确实
        '为 Button。由于此处理程序可以附加到任何
        '事件中，所以这一点很必要。
        If TypeOf sender Is Button Then
            '告知用户悬停在哪个 Button 上。
            MsgBox(CType(sender, Button).Text + " was hovered over!", _
                    MsgBoxStyle.OKOnly, Me.Text)
        End If
    End Sub


    '此子例程可处理在紧密绑定控件示例中创建的 Button 的 Click 事件。
    '它在 MsgBox 中显示 Button 的 Tag 中的文本。
    '（Button 按钮在“sender”参数中提供。
    '尽管这些事件处理函数很复杂，
    '也无需预先进行定义，除非使用了 Reflection.Emit。）
    Private Sub SpeakTextClickHandler(ByVal sender As System.Object, _
        ByVal e As System.EventArgs)

        '检查发送方是否为按钮，它是否附加了
        '有效的、紧密耦合的 TextBox 对象
        '作为其 Tag 属性。
        If TypeOf sender Is Button Then
            '创建要就地使用的按钮对象。
            Dim myButton As Button = CType(sender, Button)
            '检查 Button 在其 Tag 属性中是否具有 TextBox。
            If TypeOf myButton.Tag Is TextBox Then
                '将文本显示给用户。
                MsgBox(CType(myButton.Tag, TextBox).Text, MsgBoxStyle.OKOnly, _
                    Me.Text)
            End If
        End If
    End Sub

    '此函数向传递的控件集合中添加一个 ComboBox，
    '并添加关联的 Label 控件来显示调查问题。
    Private Function Survey_AddComboBox(ByVal inNode As XmlNode, _
        ByVal inControls As Control.ControlCollection, _
        ByVal location As Point, ByVal tag As String) As Point

        ' 创建一个新控件。
        Dim newComboBox As New ComboBox

        ' 设置控件的一些属性。
        newComboBox.Text = ""
        newComboBox.Name = inNode.Attributes("name").Value
        newComboBox.Tag = tag
        newComboBox.Width = controlWidth

        ' 创建一个临时 XML 节点，以便在传递的节点中
        ' 检索有关响应节点的信息时使用。
        ' 获取响应节点。
        For Each node As XmlNode In inNode.SelectNodes("responses/response")
            '添加响应节点的 InnerText 作为
            '下拉选项的值。
            newComboBox.Items.Add(node.InnerText)
            '如果已指定默认值，则请使用该值作为当前文本。
            If Not node.Attributes("default") Is Nothing Then
                If node.Attributes("default").Value = "true" Then
                    newComboBox.Text = node.InnerText
                End If
            End If
        Next

        ' 创建一个 Label 并将其添加到集合中。
        Dim newLabel As New Label

        ' 设置控件的一些属性。
        newLabel.Name = newComboBox.Name & "Label"
        newLabel.Text = inNode.SelectSingleNode("text").InnerText
        newLabel.Width = controlWidth

        ' 将控件添加到控件集合中，将其位置重置为下一控件
        ' 的位置。
        newLabel.Location = location
        inControls.Add(newLabel)
        location.Y += newLabel.Height

        ' 将控件添加到控件集合中，将其位置重置为下一控件
        ' 的位置。
        newComboBox.Location = location
        inControls.Add(newComboBox)
        location.Y += newComboBox.Height + 10

        '发送回用于添加下一控件的位置。
        Return location
    End Function

    '此函数向传递的控件集合中添加一个 ListBox，
    '并添加关联的 Label 控件来显示调查问题。
    Private Function Survey_AddListBox(ByVal inNode As XmlNode, _
        ByVal inControls As Control.ControlCollection, _
        ByVal location As Point, ByVal tag As String, _
        ByVal isMultiSelect As Boolean) As Point

        ' 创建一个新控件。
        Dim newList As New ListBox

        ' 设置控件的一些属性。
        newList.Text = ""
        newList.Name = inNode.Attributes("name").Value
        newList.Tag = tag
        newList.Width = controlWidth

        '由于此函数可用于多个或单个选择列表
        '框，所以请根据传递的 isMultiSelect Boolean 变量
        '设置正确的 SelectionMode。
        If isMultiSelect Then
            newList.SelectionMode = SelectionMode.MultiSimple
        Else
            newList.SelectionMode = SelectionMode.One
        End If


        ' 创建一个临时 XML 节点，以便在传递的节点中
        ' 检索有关响应节点的信息时使用。
        ' 添加响应节点的 InnerText 作为
        ' 列表框选项的值。
        For Each node As XmlNode In inNode.SelectNodes("responses/response")
            newList.Items.Add(node.InnerText)
            '如果已指定默认值，则请使用该值作为当前文本。
            If Not node.Attributes("default") Is Nothing Then
                If node.Attributes("default").Value = "true" Then
                    newList.Text = node.InnerText
                End If
            End If
        Next

        '创建一个 Label 并将其添加到集合中
        Dim newLabel As New Label

        '设置控件的一些属性
        newLabel.Name = newList.Name & "Label"
        newLabel.Text = inNode.SelectSingleNode("text").InnerText
        newLabel.Width = controlWidth

        ' 将控件添加到控件集合中，将其位置重置为下一控件
        ' 的位置。
        newLabel.Location = location
        inControls.Add(newLabel)
        location.Y += newLabel.Height

        ' 将控件添加到控件集合中，将其位置重置为下一控件
        ' 的位置。
        newList.Location = location
        inControls.Add(newList)
        location.Y += newList.Height + 10

        ' 发送回下一控件的位置。
        Return location
    End Function

    '此函数向传递的控件集合添加 GroupBox，
    '以及所有相应的单选按钮，每个可用的响应对应一个按钮。
    '它还添加关联的 Label 控件来显示调查问题。
    Private Function Survey_AddRadioButtons(ByVal inNode As XmlNode, _
        ByVal inControls As Control.ControlCollection, _
        ByVal location As Point, ByVal tag As String) As Point

        '必须创建 GroupBox 来包含单选按钮
        '否则，无法从逻辑上区分它们与窗体中的
        '其他单选按钮。
        Dim newGroupBox As New GroupBox

        ' 设置控件的一些属性。
        newGroupBox.Text = ""
        newGroupBox.Name = inNode.Attributes("name").Value
        newGroupBox.Tag = tag
        newGroupBox.Width = controlWidth + 20

        '创建一些有用的变量，以用于下面的代码块中。
        Dim newRadio As RadioButton
        Dim radioPoint As New Point(5, 10)

        '循环访问每个响应，并将其添加为新的单选按钮。
        For Each node As XmlNode In inNode.SelectNodes("responses/response")
            '创建单选按钮。
            newRadio = New RadioButton
            '添加相应的属性。
            newRadio.Text = node.InnerText
            newRadio.Location = radioPoint
            radioPoint.Y += newRadio.Height

            '将默认值设置为选定的单选按钮，但条件是
            '默认属性存在且设置为 true。
            If Not node.Attributes("default") Is Nothing Then
                If node.Attributes("default").Value = "true" Then
                    newRadio.Checked = True
                End If
            End If
            '向 GroupBox 中添加控件。
            newGroupBox.Controls.Add(newRadio)
        Next

        '根据包含的单选按钮，重置
        '文本框的高度。
        newGroupBox.Height = radioPoint.Y + 5

        ' 创建一个 Label 并将其添加到集合中。
        Dim newLabel As New Label

        '修复此 Label 的属性。
        newLabel.Name = newGroupBox.Name & "Label"
        newLabel.Text = inNode.SelectSingleNode("text").InnerText
        newLabel.Width = controlWidth

        ' 将控件添加到控件集合中，将其位置重置为下一控件
        ' 的位置。
        newLabel.Location = location
        inControls.Add(newLabel)
        location.Y += newLabel.Height - 5

        ' 将控件添加到控件集合中，将其位置重置为下一控件
        ' 的位置。
        newGroupBox.Location = location
        inControls.Add(newGroupBox)
        location.Y += newGroupBox.Height + 10

        ' 发送回下一控件的位置。
        Return location
    End Function

    '此函数向传递的控件集合中添加 TextBox，并添加关联的
    'Label 控件来显示调查问题。
    Private Function Survey_AddTextBox(ByVal inNode As XmlNode, _
        ByVal inControls As Control.ControlCollection, _
        ByVal location As Point, ByVal tag As String _
        ) As Point

        ' 创建一个新控件。
        Dim newText As New TextBox

        '填充一些相应的属性。
        If Not inNode.SelectSingleNode("defaultResponse") Is Nothing Then
            newText.Text = inNode.SelectSingleNode("defaultResponse").InnerText
        End If
        If Not inNode.Attributes("name") Is Nothing Then
            newText.Name = inNode.Attributes("name").Value
        End If
        newText.Tag = tag
        newText.Width = controlWidth

        '设置 MaxLength 属性（根据 XML 节点信息）。
        If Not inNode.SelectSingleNode("maxCharacters") Is Nothing Then
            newText.MaxLength = Integer.Parse(inNode.SelectSingleNode("maxCharacters").InnerText)
        End If

        '计算应允许的行数。
        If newText.MaxLength > 0 Then
            Dim numLines As Integer = (newText.MaxLength \ charPerLine) + 1

            '计算文本框应具有的大小，以及
            '是否需要滚动条。
            If numLines = 1 Then
                newText.Multiline = False
            Else
                If numLines >= 4 Then
                    newText.Multiline = True
                    newText.Height = 4 * lineHeight
                    newText.ScrollBars = ScrollBars.Vertical
                Else
                    newText.Multiline = True
                    newText.Height = numLines * lineHeight
                    newText.ScrollBars = ScrollBars.None
                End If

            End If

        End If

        ' 创建一个 Label 并将其添加到集合中。
        Dim newLabel As New Label
        newLabel.Name = newText.Name & "Label"
        If Not inNode.SelectSingleNode("text") Is Nothing Then
            newLabel.Text = inNode.SelectSingleNode("text").InnerText
        End If
        newLabel.Width = controlWidth

        ' 将控件添加到控件集合中，将其位置重置为下一控件
        ' 的位置。
        newLabel.Location = location
        inControls.Add(newLabel)
        location.Y += newLabel.Height

        ' 将控件添加到控件集合中，将其位置重置为下一控件
        ' 的位置。
        newText.Location = location
        inControls.Add(newText)
        location.Y += newText.Height + 10

        ' 发送回下一控件的位置。
        Return location
    End Function



    Private Sub ExitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExitToolStripMenuItem.Click
        End
    End Sub
End Class